
set more off
quiet: do "INDIVIDUAL 1a. Merge TWM.do"


* delete non-Muslim majority (Bosnia-Herzegovina, Russia, Thailand)
drop if pctmuslims < .5


*===============================================================================
* Prepare Control Variables
*===============================================================================

* religiosity indicators
recode Q34 (1=6) (2=5) (3=4) (4=3) (5=2) (6=1) (7/.=.), gen(gotomosque)
recode Q36 (1=4) (2=3) (3=2) (4=1) (5/.=.), gen(relimportant)
recode Q61 (1=7) (2=6) (3=5) (4=4) (5=3) (6=2) (7=1) (8/.=.), gen(freqpray)
recode Q65 (1=5) (2=4) (3=3) (4=2) (5=1) (6/.=.), gen(readkoran)

* sex (female)
rename Q95 female
replace female = female-1

* age
recode Q96 (0/17=.) (98/.=.), gen(age)

* rural
rename Q133 rural
replace rural = rural-1

* political efficacy
recode Q12 (5/.=.), gen (efficacy)

* personal economic situation
recode Q7 (1=4) (2=3) (3=2) (4=1) (5/.=.), gen (personalecon)

* favor democracy to strong leader
recode Q14 (2=0) (3/.=.), gen (favordem)

* islam one true faith to heaven
recode Q55 (2/4=0) (5/.=.), gen (onetruefaith)

* interfaith activity
gen interfaith = .
replace interfaith = 1 if Q70==1 | Q70a==1
replace interfaith = 0 if Q70==2 | Q70a==2


*edu follows Blaydes and Lindzer 2012, p.235
*less than secondary, secondary-college/university (not finished), >=university
*local cty "AFG ALB ALG AZE BAN BOS EGY IDN IRN IRQ JOR KAZ KOS KYR LEB MAL NIG PAK PAL RUS TAJ THA TUN TUR UZB"
*set more off
*foreach icty of local cty {
*	labelbook Q101`icty'
*}
recode Q101AFG (1/4=1) (5/6=2) (7/8=3) (9/.=.)
recode Q101ALB (1/3=1) (4/6=2) (7/8=3) (9/.=.)
recode Q101ALG (1/3=1) (4=2) (5/6=3) (7/8=2) (9/.=.)
recode Q101AZE (1/2=1) (3/4=2) (5=3) (6/.=.)
recode Q101BAN (1/4=1) (5/8=2) (9/12=3) (13/.=.)
recode Q101BOS (1/5=1) (6/9=2) (10/12=3) (13/.=.)
recode Q101EGY (1/6=1) (7/8=2) (9=3) (10/.=.)
recode Q101IDN (1/6=1) (7/8=2) (9=3) (10/.=.)
recode Q101IRN (1/6=1) (7/10=2) (11/12=3) (13/.=.)
recode Q101IRQ (1/3=1) (4/5=2) (6/7=3) (8/.=.)
recode Q101JOR (1/4=1) (5/6=2) (7=3) (8/.=.)
recode Q101KAZ (1/3=1) (4/7=2) (8=3) (9/.=.)
recode Q101KOS (1/6=1) (7/9=2) (10=3) (11/.=.)
recode Q101KYR (1/4=1) (5/7=2) (8=3) (9/.=.)
recode Q101LEB (1/5=1) (6/7=2) (8=3) (9/.=.)
recode Q101MAL (1/3=1) (4/7=2) (8/9=3) (10/.=.)
recode Q101NIG (1/6=1) (7/8=2) (9/11=3) (12/.=.)
recode Q101PAK (1/6=1) (7/9=2) (10/11=3) (12/.=.)
recode Q101PAL (1/4=1) (5/6=2) (7/9=3) (10/.=.)
recode Q101RUS (1/3=1) (4/7=2) (8/9=3) (10/.=.)
recode Q101TAJ (1/2=1) (3/5=2) (6=3) (7/.=.)
recode Q101THA (1/3=1) (4/5=2) (6=3) (7/.=.)
recode Q101TUN (1/3=1) (4=2) (5=3) (6/.=.)
recode Q101TUR (1/4=1) (5/6=2) (7/9=3) (10/.=.)
recode Q101UZB (1/5=1) (6/8=2) (9=3) (10/.=.)

*because for each respondent, values of other countries will be missing
egen edu = rowmin(Q101*)

* logging gdp per capita 2010
gen loggdppc = log(gdppc2010)

* mazhab (sunni, shia, just a muslim, others)
recode Q31rec (3/91=4) (92/97 = 3) (98/.=.), gen(mazhab)

* shias are muslims
recode Q41b (2=0) (3/.=.), gen(shiamuslim)

* sunnis are muslims
recode Q41c (2=0) (3/.=.), gen(sunnimuslim)

* generate Sunni-majority countries
gen sunnimajority = 0
replace sunnimajority = 1 if 	icountry == "Afghanistan" | icountry == "Algeria" | icountry == "Bangladesh" | ///
								icountry == "Egypt" | icountry == "Jordan" | icountry == "Lebanon" | ///
								icountry == "Malaysia" | icountry == "Morocco" | icountry == "Niger" | ///
								icountry == "Pakistan" | icountry == "Palestinian Territories" | ///
								icountry == "Tajikistan" | icountry == "Tunisia" | icountry == "Turkey"

* generate Shia-majority countries
gen shiamajority = 0
replace shiamajority = 1 if 	icountry == "Iran" | icountry == "Iraq"

* generate percent Sunni in Sunni-majority countries
gen pctsunni = .
replace pctsunni = 89.20 if icountry == "Afghanistan"
replace pctsunni = 95.90 if icountry == "Algeria"
replace pctsunni = 94.28 if icountry == "Bangladesh"
replace pctsunni = 90.13 if icountry == "Egypt"
replace pctsunni = 93.48 if icountry == "Jordan"
replace pctsunni = 50.64 if icountry == "Lebanon"
replace pctsunni = 77.71 if icountry == "Malaysia"
replace pctsunni = 67.49 if icountry == "Morocco"
replace pctsunni = 59.91 if icountry == "Niger"
replace pctsunni = 78.01 if icountry == "Pakistan"
replace pctsunni = 83.55 if icountry == "Palestinian Territories"
replace pctsunni = 88.87 if icountry == "Tajikistan"
replace pctsunni = 60.97 if icountry == "Tunisia"
replace pctsunni = 91.70 if icountry == "Turkey"


* generate dummy for Middle East region
replace Region5 = "Europe" if icountry == "Bosnia and Herzegovina"
replace Region5 = "Middle East-North Africa" if icountry == "Palestinian Territories"

gen medummy = 0
replace medummy = 1 if Region5 == "Middle East-North Africa"



*===============================================================================
* Prepare Bonding Questions
*===============================================================================

recode Q49 (1=5) (2=4) (4=2) (5=1) (6/.=.), gen(bonding1)


*===============================================================================
* Prepare Tolerance Questions
*===============================================================================

* Muslim and Christian have a lot in common (Q24)
recode Q24 (1=0) (2=1) (3/.=.), gen(verydifferent)

* OK son marries a Christian (Q37)
recode Q37 (5=3) (3=4) (4=5) (6/.=.), gen(son)

* OK daughter marries a Christian (Q38)
recode Q38 (5=3) (3=4) (4=5) (6/.=.), gen(daughter)


*===============================================================================
**Polychoric factor analyses**
*===============================================================================

**Defining matrix of polychoric correlations**
polychoric son daughter verydifferent
display r(sum_w)
matrix r=r(R)

**Transforming matrix to make it positive definite**
mata
rho = st_matrix("r")
X=.
L=.
symeigensystem( rho, X, L )
Lplus = L
for(k=1;k<=cols(L);k++) {
  Lplus[1,k] = max( (Lplus[1,k], 0 ) )
}
rho_plus = X * diag( Lplus ) * X'
_makesymmetric(rho_plus)
st_matrix( "rho_plus", rho_plus )
end

**Making diagonal elements of positive definite matrix = 1**
matrix rho_plus[1,1]=1
matrix rho_plus[2,2]=1
matrix rho_plus[3,3]=1


**Defining row and column names of positive-definite matrix**
matrix rownames rho_plus=son daughter verydifferent
matrix colnames rho_plus=son daughter verydifferent

**Factor analysis**	
factormat rho_plus, n(20810) pcf
rotate, promax

predict fac_attitudes

** Reliability: alpha = .67; inter-item corr = .50
alpha son daughter verydifferent

*===============================================================================
* Standardize Non-Categorical Variables
*===============================================================================

egen zson = std(son)
egen zdaughter = std(daughter)

egen zbonding1 = std(bonding1)

egen zfreqpray = std(freqpray)
egen zedu = std(edu)
egen zage = std(age)
egen zefficacy = std(efficacy)
egen zpersonalecon = std(personalecon)

egen zloggdppc = std(loggdppc)
egen zpctmuslims = std(pctmuslims)
egen zGRI = std(GRI)
egen zpolity2 = std(polity2)
egen zrdi = std(rdi2010)

egen zpctsunni = std(pctsunni)

egen zfac_attitudes = std(fac_attitudes)
